<?php
$linkBn = URL_BASE.'data/galeriaVideo.php';
$chBn = curl_init($linkBn);
curl_setopt($chBn, CURLOPT_RETURNTRANSFER, true);
curl_setopt($chBn, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($chBn, CURLOPT_USERAGENT, "Mozilla/5.0");
$responseBn = curl_exec($chBn);
curl_close($chBn);
$imagens = json_decode($responseBn, true);

// Definição da paginação
$imagensPorPagina = 3; // Quantidade de imagens por página
$paginaAtual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$totalImagens = count($imagens);
$totalPaginas = ceil($totalImagens / $imagensPorPagina);
$offset = ($paginaAtual - 1) * $imagensPorPagina;
$imagensPaginadas = array_slice($imagens, $offset, $imagensPorPagina);
?>

<section class="spaceSection">
	<div class="container">
		<div class="row">
			<div class="col-md-12" style="padding-top: 30px;">
				<h2 class="specialTitleGalery">Galeria de Vídeos</h2>
			</div>
			<div class="col-md-12">&nbsp;</div>

			<?php foreach($imagensPaginadas as $imagem): ?>
			<div class="col-md-4 d-none d-md-block">
				<iframe src="https://www.youtube.com/embed/<?php echo $imagem['recurso']; ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen class="boxImage"></iframe>
			</div>
			
			<div class="col-md-4 d-md-none">
				<iframe src="https://www.youtube.com/embed/<?php echo $imagem['recurso']; ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen class="boxImageMobile"></iframe>
			</div>
			
			<?php endforeach; ?>
		</div>
		
		<div class="col-md-12">&nbsp;</div>

		<!-- Paginação -->
		<div class="row">
			<div class="col-md-12 text-center">
				<ul class="pagination">
					<?php if($paginaAtual > 1): ?>
						<li><a href="/galeriaVideos/<?php echo $paginaAtual - 1; ?>" class="btn btn-info"style="border: 1px solid #ffffff;">&laquo; Anterior</a></li>
					<?php endif; ?>

					<?php for($i = 1; $i <= $totalPaginas; $i++): ?>
						<li class="<?php echo ($i == $paginaAtual) ? 'active' : ''; ?>" style="border: 1px solid #ffffff;">
							<a href="/galeriaVideos/<?php echo $i; ?>" class="btn btn-success"><?php echo $i; ?></a>
						</li>
					<?php endfor; ?>

					<?php if($paginaAtual < $totalPaginas): ?>
						<li><a href="/galeriaVideos/<?php echo $paginaAtual + 1; ?>" class="btn btn-info"style="border: 1px solid #ffffff;">Próxima &raquo;</a></li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>
</section>
