<?php
$linkBn = URL_BASE.'data/galeriaImagem.php';
$chBn = curl_init($linkBn);
curl_setopt($chBn, CURLOPT_RETURNTRANSFER, true);
curl_setopt($chBn, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($chBn, CURLOPT_USERAGENT, "Mozilla/5.0");
$responseBn = curl_exec($chBn);
curl_close($chBn);
$imagens = json_decode($responseBn, true);

// Definição da paginação
$imagensPorPagina = 9; // Quantidade de imagens por página
$paginaAtual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$totalImagens = count($imagens);
$totalPaginas = ceil($totalImagens / $imagensPorPagina);
$offset = ($paginaAtual - 1) * $imagensPorPagina;
$imagensPaginadas = array_slice($imagens, $offset, $imagensPorPagina);
?>

<section class="spaceSection">
	<div class="container">
		<div class="row">
			<div class="col-md-12" style="padding-top: 30px;">
				<h2 class="specialTitleGalery">Galeria de Imagens</h2>
			</div>
			<div class="col-md-12">&nbsp;</div>

			<?php foreach($imagensPaginadas as $imagem): ?>
			<div class="col-md-4 d-none d-md-block">
				<a data-toggle="modal" data-target=".imagem-<?php echo $imagem['id']; ?>" style="cursor: pointer;">
					<div class="boxImage" style="background-image:url('<?php echo URL_BASE.'assets/images/'.$imagem['recurso']; ?>'); background-size: cover; background-repeat: no-repeat; background-position-x: center;">
						<div class="descGaleria"><?php echo $imagem['descricao']; ?></div>
					</div>
				</a>
			</div>
			
			<div class="col-md-4 d-md-none">
				<a data-toggle="modal" data-target=".imagem-<?php echo $imagem['id']; ?>" style="cursor: pointer;">
					<div class="boxImageMobile" style="background-image:url('<?php echo URL_BASE.'assets/images/'.$imagem['recurso']; ?>'); background-size: cover; background-repeat: no-repeat; background-position-x: center;">
						<div class="descGaleriaMobile"><?php echo $imagem['descricao']; ?></div>
					</div>
				</a>
			</div>
			
			<div class="modal fade imagem-<?php echo $imagem['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
			  <div class="modal-dialog modal-lg">
				<div class="modal-content" align="center">
				  <img src="<?php echo URL_BASE.'assets/images/'.$imagem['recurso']; ?>" alt="<?php echo $imagem['altText']; ?>">
				</div>
			  </div>
			</div>
			<?php endforeach; ?>
		</div>
		
		<div class="col-md-12">&nbsp;</div>

		<!-- Paginação -->
		<div class="row">
			<div class="col-md-12 text-center">
				<ul class="pagination">
					<?php if($paginaAtual > 1): ?>
						<li><a href="/galeriaImages/<?php echo $paginaAtual - 1; ?>" class="btn btn-info"style="border: 1px solid #ffffff;">&laquo; Anterior</a></li>
					<?php endif; ?>

					<?php for($i = 1; $i <= $totalPaginas; $i++): ?>
						<li class="<?php echo ($i == $paginaAtual) ? 'active' : ''; ?>" style="border: 1px solid #ffffff;">
							<a href="/galeriaImages/<?php echo $i; ?>" class="btn btn-success"><?php echo $i; ?></a>
						</li>
					<?php endfor; ?>

					<?php if($paginaAtual < $totalPaginas): ?>
						<li><a href="/galeriaImages/<?php echo $paginaAtual + 1; ?>" class="btn btn-info"style="border: 1px solid #ffffff;">Próxima &raquo;</a></li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
	</div>
</section>
