<section class="bgGaleria">
	&nbsp;
</section>

<section class="spaceSection" id="calendario">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<h2 class="text-center titleSection">Galeria de Fotos</h2>
			</div>
		</div>
	</div>
</section>

<section class="spaceSection">
    <div class="container">
        <div class="row">
            <?php
            $linkEv = URL_BASE.'data/galeria_eventos.php';
            $chEv = curl_init($linkEv);
            curl_setopt($chEv, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($chEv, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($chEv, CURLOPT_USERAGENT, "Mozilla/5.0");
            $responseEv = curl_exec($chEv);
            curl_close($chEv);
            $events = json_decode($responseEv, true);
            
            foreach ($events as $event) {
                ?>
                <div class="col-md-12 titleEvGaleria">
                    <h4><?php echo $event['descricao']; ?> | <?php echo $event['data']; ?></h4>
                </div>
                <div class="col-md-12">
                    <div class="row gallery-container" id="gallery-<?php echo $event['id']; ?>">
                        <?php
                        $linkFt = URL_BASE.'data/fotos_galeria_eventos_of.php?id='.$event['id'];
                        $chFt = curl_init($linkFt);
                        curl_setopt($chFt, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($chFt, CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($chFt, CURLOPT_USERAGENT, "Mozilla/5.0");
                        $responseFt = curl_exec($chFt);
                        curl_close($chFt);
                        $images = json_decode($responseFt, true);
                        $totalImages = count($images);
                        
                        // Exibe as primeiras 4 imagens
                        $initialImages = array_slice($images, 0, 4); // Exibe apenas as 4 primeiras
                        foreach ($initialImages as $image) {
                            ?>
                            <div class="col-md-3 gallery-item" data-event-id="<?php echo $event['id']; ?>">
                                <div class="aspect-ratio-4-3" style="background-image: url(<?php echo URL_BASE.'assets/images/'.$image['imagem']; ?>); background-size: cover; background-position: center; margin-top: 10px;">
                                    <a class="icon-position" data-toggle="modal" data-target=".<?php echo 'image-'.$image['id']; ?>">
                                        <i class="fa-solid fa-expand"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="modal fade <?php echo 'image-'.$image['id']; ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <img src="<?php echo URL_BASE.'assets/images/'.$image['imagem']; ?>" style="max-width: 100%">
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    
                    <?php
					if($event['qFotos'] > 4){
					?>
					<div class="text-center" style="margin-top: 15px;">
						<button class="btn btn-primary btn-load-more" data-event-id="<?php echo $event['id']; ?>" data-offset="4">Carregar Mais</button>
					</div>
					<?php
					}
					?>

                </div>
                <?php
            }
            ?>
        </div>
    </div>
</section>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const loadMoreButtons = document.querySelectorAll(".btn-load-more");

    loadMoreButtons.forEach(button => {
        button.addEventListener("click", function () {
            const eventId = this.getAttribute("data-event-id");
            const galleryContainer = document.getElementById(`gallery-${eventId}`);
            const offset = parseInt(this.getAttribute("data-offset"));
            const linkFt = `<?php echo URL_BASE; ?>data/fotos_galeria_eventos_of.php?id=${eventId}&offset=${offset}`;

            console.log("Carregando mais fotos para o evento:", eventId);
            console.log("Offset atual:", offset);
            console.log("Link de requisição:", linkFt);

            // Faz a requisição para carregar mais fotos
            fetch(linkFt)
                .then(response => {
                    if (!response.ok) {
                        throw new Error("Erro na requisição para carregar mais fotos.");
                    }
                    return response.json();
                })
                .then(images => {
                    console.log("Imagens retornadas:", images);

                    if (images && images.length > 0) {
                        images.forEach(image => {
                            // Criação do elemento da galeria
                            const imageElement = document.createElement('div');
                            imageElement.classList.add('col-md-3', 'gallery-item');
                            imageElement.innerHTML = `
                                <div class="aspect-ratio-4-3" style="background-image: url(<?php echo URL_BASE; ?>assets/images/${image.imagem}); background-size: cover; background-position: center; margin-top: 10px;">
                                    <a class="icon-position" data-toggle="modal" data-target=".image-${image.id}">
                                        <i class="fa-solid fa-expand"></i>
                                    </a>
                                </div>
                            `;
                            galleryContainer.appendChild(imageElement);

                            // Criação do modal correspondente
                            const modalElement = document.createElement('div');
                            modalElement.classList.add('modal', 'fade', `image-${image.id}`);
                            modalElement.setAttribute('tabindex', '-1');
                            modalElement.setAttribute('role', 'dialog');
                            modalElement.setAttribute('aria-hidden', 'true');
                            modalElement.innerHTML = `
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <img src="<?php echo URL_BASE; ?>assets/images/${image.imagem}" style="max-width: 100%">
                                    </div>
                                </div>
                            `;
                            document.body.appendChild(modalElement);
                        });

                        // Atualiza o botão para carregar as próximas imagens
                        button.setAttribute("data-offset", offset + images.length);

                        // Se não houver mais imagens, ocultamos o botão
                        if (images.length < 4) {
                            button.style.display = "none";
                        }
                    } else {
                        console.log("Não há mais imagens para carregar.");
                        button.style.display = "none";
                    }
                })
                .catch(error => {
                    console.error("Erro ao carregar mais fotos:", error);
                });
        });
    });

    // Configura os eventos iniciais do modal
    $('[data-toggle="modal"]').off('click').on('click', function (e) {
        const target = $(this).data('target');
        $(target).modal('show');
    });
});
</script>