<section class="homeIni">
	<div class="container">
		<div class="row">
			<div class="col-md-1">
				&nbsp;
			</div>
			<div class="col-md-6" style="padding: 20px 40px 0 40px;">
			  <div class="bgKids position-relative">
				<div class="overlay"></div>
				<h4 class="text-center position-relative"><strong>Conheça a Área de Ensino do CACAU!</strong></h4>
			  </div>
			  <p class="text-left">Na <strong>Ong CACAU</strong>, acreditamos na <strong>educação continuada</strong> como pilar da excelência médica. Se você é médico(a) ou estudante de medicina, essa é a sua chance de aprofundar seus conhecimentos em <strong>uropediatria</strong> e vivenciar nossa rotina, tudo através de <strong>conteúdos exclusivos em vídeo!</strong></p>
			  <p class="text-left">Esse conteúdo é exclusivo para <strong>médicos</strong> e <strong>alunos de medicina</strong>.</p>
			  <p class="text-left">Preparamos uma jornada de aprendizado dinâmica e <strong>gratuita</strong> com:</p>
			  <ul>
				<li><strong>Casos Clínicos da Semana Comentados:</strong> Análises detalhadas de casos relevantes, direto para sua tela;</li>
				<li><strong>Cirurgia do Mês - Técnicas Cirúrgicas:</strong> Demonstrações em vídeo de procedimentos e técnicas inovadoras;</li>
				<li><strong>Professores Convidados:</strong> Aulas com renomados especialistas, trazendo o que há de mais atual.</li>
			  </ul>
			  <p class="text-left">Todo o material é elaborado por nosso corpo clínico de especialistas.</p>
			  <p class="text-left">Para ter acesso a todo esse conteúdo em vídeo, é simples e <strong>gratuito</strong>. Cadastre-se agora! Após o envio, nossa equipe revisará sua solicitação e, uma vez aprovada, você terá acesso imediato aos vídeos.</p>
			</div>
			<div class="col-md-4" style="padding-left: 20px;">
				<h4 class="text-center titleClr1"><strong>Cadastre-se e Faça Parte!</strong></h4><br>
				<p class="text-center">Preencha seus dados para ter acesso exclusivo à Área de Ensino do CACAU:</p>
				<div class="loginBox">
				<img src="<?php echo URL_BASE; ?>assets/images/dicionario.png" class="logoLogin">
				<?php
				if(isset($_GET['aviso']) AND $_GET['aviso'] == 1){
				?>
				<br>
				<div class="alert alert-danger" role="alert">
				  Cadastro não incluído!<br>As senhas não coincidem.
				</div>
				<br>
				<?php
				}
				if(isset($_GET['aviso']) AND $_GET['aviso'] == 2){
				?>
				<br>
				<div class="alert alert-danger" role="alert">
				  Cadastro não incluído!<br>Verifique o preenchimento dos campos solicitados.
				</div>
				<br>
				<?php
				}
				?>
				<form method="post" action="<?php echo URL_BASE; ?>controle/command/cadastro.php">
				<div class="form-group">
					<input class="form-control fieldForm" type="text" name="nome" placeholder="Nome Completo" REQUIRED>
				</div>
				<div class="form-group">
					<input class="form-control fieldForm" type="email" name="email" placeholder="E-mail" REQUIRED>
				</div>
				<div class="form-group">
					<label>Eu sou:</label><br>
					<input type="radio" name="tipo" value="0" CHECKED> Médico Formado<br>
					<input type="radio" name="tipo" value="1"> Estudante de Medicina
				</div>
				<div class="form-group">
					<input class="form-control fieldForm" type="text" name="crm" placeholder="Nº do CRM">
				</div>
				<div class="form-group">
					<select name="uf" id="estado" class="form-control fieldForm">
					  <option value="">-- Selecione o estado --</option>
					  <option value="AC">Acre</option>
					  <option value="AL">Alagoas</option>
					  <option value="AP">Amapá</option>
					  <option value="AM">Amazonas</option>
					  <option value="BA">Bahia</option>
					  <option value="CE">Ceará</option>
					  <option value="DF">Distrito Federal</option>
					  <option value="ES">Espírito Santo</option>
					  <option value="GO">Goiás</option>
					  <option value="MA">Maranhão</option>
					  <option value="MT">Mato Grosso</option>
					  <option value="MS">Mato Grosso do Sul</option>
					  <option value="MG">Minas Gerais</option>
					  <option value="PA">Pará</option>
					  <option value="PB">Paraíba</option>
					  <option value="PR">Paraná</option>
					  <option value="PE">Pernambuco</option>
					  <option value="PI">Piauí</option>
					  <option value="RJ">Rio de Janeiro</option>
					  <option value="RN">Rio Grande do Norte</option>
					  <option value="RS">Rio Grande do Sul</option>
					  <option value="RO">Rondônia</option>
					  <option value="RR">Roraima</option>
					  <option value="SC">Santa Catarina</option>
					  <option value="SP">São Paulo</option>
					  <option value="SE">Sergipe</option>
					  <option value="TO">Tocantins</option>
					</select>
				</div>
				<div class="form-group">
					<input class="form-control fieldForm" type="text" name="instituicaoEnsino" placeholder="Instituição de Ensino" id="instituicaoEnsino">
				</div>
				<div class="form-group">
					<input class="form-control fieldForm" type="password" name="senha" placeholder="Senha">
				</div>
				<div class="form-group">
					<input class="form-control fieldForm" type="password" name="senhaConfirm" placeholder="Confirmar Senha">
				</div>
				<div class="form-group">
					<button class="btn btn-success btn-block" type="submit"><i class="fa-regular fa-address-card"></i> Cadastrar</button>
				</div>
				</form>
				</div><br>
				<a href="<?php echo URL_BASE.'login'; ?>" class="btn btn-info btn-block">
					<i class="fa-solid fa-circle-user"></i> Já tenho cadastro
				</a>
			</div>
			<div class="col-md-1">
				&nbsp;
			</div>
		</div>
	</div>
</section>

<script>
$(function() {
  $("#instituicaoEnsino").autocomplete({
    source: function(request, response) {
      if (request.term.length < 3) return;

      $.ajax({
        url: "<?php echo URL_BASE; ?>data/instituicoesMedicina.json",
        dataType: "json",
        success: function(data) {
          const termo = request.term.toLowerCase();

          const resultados = data
            .filter(item => 
              item.instituicao.toLowerCase().includes(termo) || 
              item.sigla.toLowerCase().includes(termo)
            )
            .map(item => {
              const texto = `${item.codigo} - ${item.instituicao} - ${item.sigla}`;
              return { label: texto, value: texto };
            });

          response(resultados);
        },
        error: function() {
          response([]);
        }
      });
    },
    minLength: 3,
    delay: 300
  });
});
</script>

<script>
$(function() {
  function atualizarCampos() {
    const tipo = $('input[name="tipo"]:checked').val();

    if (tipo === "0") {
      // Médico Formado
      $('input[name="crm"]').closest('.form-group').show();
      $('select[name="uf"]').closest('.form-group').show();
      $('input[name="instituicaoEnsino"]').closest('.form-group').hide();
    } else {
      // Estudante
      $('input[name="crm"]').closest('.form-group').hide();
      $('select[name="uf"]').closest('.form-group').hide();
      $('input[name="instituicaoEnsino"]').closest('.form-group').show();
    }
  }

  // Atualiza ao carregar a página
  atualizarCampos();

  // Atualiza ao trocar o radio
  $('input[name="tipo"]').on('change', atualizarCampos);
});
</script>
