<section class="spaceSection">
	<div class="container">
		<div class="row">
			<div class="col-md-2">
				&nbsp;
			</div>
			<div class="col-md-8">
			  <h3 class="text-center"><strong>Seja bem-vindo(a) à Área de Ensino do CACAU!</strong></h3>
			  <p class="text-center" style="padding: 0 10px;">Que bom ter você conosco! Sua solicitação de acesso foi aprovada e agora você faz parte da nossa comunidade dedicada à <strong>uropediatria</strong>.</p>
			  <p class="text-center" style="padding: 0 10px;">Aqui, você terá acesso ilimitado aos nossos <strong>conteúdos exclusivos em vídeo</strong>, pensados para aprofundar seus conhecimentos e te conectar à rotina do Instituto CACAU.</p>
			</div>
			<div class="col-md-2">
				&nbsp;
			</div>
		</div>
		<div class="row" id="video-container">
			<!-- Vídeos serão inseridos aqui via JavaScript -->
		</div>
		<div class="col-md-12 text-center" id="loading" style="display: none;">
			<div class="progress" style="height: 30px;">
				<div class="progress-bar progress-bar-striped progress-bar-animated bg-success"
					role="progressbar"
					style="width: 100%">
					Carregando vídeos...
				</div>
			</div>
		</div>

	</div>
</section>

<div class="closeButton">
	<a href="<?php echo URL_BASE.'exit.php'; ?>">
		<i class="fa-solid fa-power-off text-danger" style="font-size: 24px;"></i>
	</a>
</div>
<div class="closeButtonText text-danger">
	SAIR
</div>

<script>
let pagina = 1;
const limite = 6;
let carregando = false;
let terminou = false;

async function carregarVideos() {
	if (carregando || terminou) return;
	carregando = true;
	document.getElementById("loading").style.display = "block";

	try {
		const response = await fetch('<?php echo URL_BASE; ?>data/galeriaVideo.php');
const todos = await response.json();

const arrayVideos = Object.values(todos); // 💡 Corrige o formato
const inicio = (pagina - 1) * limite;
const fim = pagina * limite;
const videos = arrayVideos.slice(inicio, fim);


		if (videos.length === 0) {
			terminou = true;
			return;
		}

		const container = document.getElementById("video-container");

		videos.forEach(imagem => {
			const col = document.createElement("div");
			col.className = "col-md-4 col-12 mb-4";

			col.innerHTML = `
				<iframe src="https://www.youtube.com/embed/${imagem.recurso}" 
					title="YouTube video player" 
					frameborder="0" 
					allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
					referrerpolicy="strict-origin-when-cross-origin" 
					allowfullscreen 
					class="boxImage w-100"></iframe>
					<h5 class="text-center specialTitleServicesHome">${imagem.descricao}</h5>
			`;
			container.appendChild(col);
		});

		pagina++;
	} catch (error) {
		console.error("Erro ao carregar vídeos:", error);
	} finally {
		document.getElementById("loading").style.display = "none";
		carregando = false;
	}
}

// Detecta scroll até o final da página
window.addEventListener("scroll", () => {
	if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 100) {
		carregarVideos();
	}
});

// Carrega a primeira página ao iniciar
carregarVideos();
</script>