<?php
require "/home/desenvwor/public_html/videos/config/config.php";

// Carrega o autoloader do Composer
require __DIR__ . '/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$conecta = new mysqli(BD_HOST, BD_USUARIO, BD_SENHA, BD_BANCO);

// Verifica conexão
if ($conecta->connect_error) {
    die("Erro na conexão com o banco: " . $conecta->connect_error);
}

// Recebendo os dados do formulário
$nome         		= trim($_POST['nome'] ?? '');
$email        		= trim($_POST['email'] ?? '');
$tipo     	  		= trim($_POST['tipo'] ?? '');
$crm     	  		= trim($_POST['crm'] ?? '');
$uf     	  		= trim($_POST['uf'] ?? '');
if($tipo == 0){
$crmUf		  		= $crm.' - '.$uf;
$instituicaoEnsino	= NULL;}
if($tipo == 1){
$crmUf		  		= NULL;
$instituicaoEnsino	= trim($_POST['instituicaoEnsino'] ?? '');}
$senha        		= $_POST['senha'] ?? '';
$senhaConfirm 		= $_POST['senhaConfirm'] ?? '';

// Verifica se as senhas coincidem
if ($senha !== $senhaConfirm) {
    header("Location: " . URL_BASE . "cadastro/1");
    exit;
}

// Criptografando a senha (MD5)
$senhaCriptografada = md5($senha);

// Prepara e executa o INSERT
$stmt = $conecta->prepare("INSERT INTO usuariosLeitura (nome, email, tipo, crmUf, instituicaoEnsino, senha) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssss", $nome, $email, $tipo, $crmUf, $instituicaoEnsino, $senhaCriptografada);

if ($stmt->execute()) {
    try {
        // 1. E-mail para o usuário
        $mailUser = new PHPMailer(true);
        $mailUser->isSMTP();
        $mailUser->Host       = GHOST;
        $mailUser->SMTPAuth   = true;
        $mailUser->Username   = GUSER;
        $mailUser->Password   = GPWD;
        $mailUser->SMTPSecure = 'ssl';
        $mailUser->Port       = 465;

        $mailUser->setFrom(GUSER, 'ONG Cacau');
        $mailUser->addAddress($email, $nome);

        $mailUser->isHTML(true);
		$mailUser->CharSet = 'UTF-8';
		$mailUser->Encoding = 'base64';
        $mailUser->Subject = 'Cadastro recebido - ONG Cacau';
        $mailUser->Body = '
						  <div style="background-color:#f5f5f5;padding:30px 0;font-family:Arial,sans-serif;">
							<div style="max-width:600px;margin:0 auto;background-color:#ffffff;border-radius:8px;overflow:hidden;box-shadow:0 0 10px rgba(0,0,0,0.05);">
							  <div style="padding:20px;text-align:center;">
								<img src="' . URL_BASE . 'assets/images/Logo-CACAU.png" alt="ONG Cacau" style="max-width:180px;margin-bottom:20px;" />
								<h2 style="color:#333333;">Cadastro recebido com sucesso!</h2>
								<p style="color:#555555;font-size:16px;line-height:1.6;">
								  Olá <strong>' . $nome . '</strong>,
								</p>
								<p style="color:#555555;font-size:16px;line-height:1.6;">
								  Seu cadastro foi realizado com sucesso e está <strong>aguardando validação</strong> da administração da ONG Cacau.
								</p>
								<p style="color:#555555;font-size:16px;line-height:1.6;">
								  Assim que for aprovado, você receberá uma confirmação por e-mail.
								</p>
								<p style="margin-top:30px;color:#888888;font-size:14px;">
								  Com carinho,<br>Equipe da ONG Cacau
								</p>
							  </div>
							</div>
						  </div>
						';

        $mailUser->send();

        // 2. E-mail para administração
        $mailAdmin = new PHPMailer(true);
        $mailAdmin->isSMTP();
        $mailAdmin->Host       = GHOST;
        $mailAdmin->SMTPAuth   = true;
        $mailAdmin->Username   = GUSER;
        $mailAdmin->Password   = GPWD;
        $mailAdmin->SMTPSecure = 'ssl';
        $mailAdmin->Port       = 465;

        $mailAdmin->setFrom(GUSER, 'ONG Cacau - Sistema');
        $mailAdmin->addAddress('michel@worksmidia.com.br', 'Administração - Teste');

        $mailAdmin->isHTML(true);
		$mailAdmin->CharSet = 'UTF-8';
		$mailAdmin->Encoding = 'base64';
        $mailAdmin->Subject = 'Novo cadastro no site - ONG Cacau';
        $mailAdmin->Body = '
							  <div style="background-color:#f5f5f5;padding:30px 0;font-family:Arial,sans-serif;">
								<div style="max-width:600px;margin:0 auto;background-color:#ffffff;border-radius:8px;overflow:hidden;box-shadow:0 0 10px rgba(0,0,0,0.05);">
								  <div style="padding:20px;text-align:center;">
									<img src="' . URL_BASE . 'assets/images/Logo-CACAU.png" alt="ONG Cacau" style="max-width:180px;margin-bottom:20px;" />
									<h2 style="color:#333333;">Novo cadastro no site</h2>
									<p style="color:#555555;font-size:16px;line-height:1.6;">
									  Um novo usuário realizou o cadastro e está aguardando aprovação:
									</p>
									<div style="color:#333333;text-align:left;margin:20px auto;max-width:400px;">
									  <p><strong>Nome:</strong> ' . $nome . '</p>
									  <p><strong>E-mail:</strong> ' . $email . '</p>
									  <p><strong>Telefone:</strong> ' . $telefone . '</p>
									</div>
									<p style="color:#555555;font-size:16px;line-height:1.6;">
									  A validação deve ser feita pela administração da plataforma.
									</p>
									<a href="' . URL_BASE . 'controle" style="display:inline-block;margin-top:20px;padding:12px 24px;background-color:#4CAF50;color:#fff;text-decoration:none;border-radius:6px;font-weight:bold;">
									  Aprovar o usuário
									</a>
									<p style="margin-top:30px;color:#888888;font-size:14px;">
									  Sistema automático - ONG Cacau
									</p>
								  </div>
								</div>
							  </div>
							';


        $mailAdmin->send();

    } catch (Exception $e) {
        error_log("Erro ao enviar e-mail: " . $e->getMessage());
        // Você também pode gravar isso num log de erro próprio se quiser
    }

    header("Location: " . URL_BASE . "login/ok");
} else {
    header("Location: " . URL_BASE . "cadastro/2");
}

// Finaliza
$stmt->close();
$conecta->close();
?>
