<?php
require_once "/home/desenvwor/public_html/videos/config/config.php"; // para URL_BASE e conexão
require __DIR__ . '/vendor/autoload.php'; // PHPMailer autoload

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$aprovado = isset($_GET['aprovado']) ? intval($_GET['aprovado']) : 0;

if ($id <= 0) {
    exit("ID inválido.");
}

$conecta = new mysqli(BD_HOST, BD_USUARIO, BD_SENHA, BD_BANCO);
if ($conecta->connect_error) {
    exit("Erro ao conectar ao banco de dados.");
}

// Atualiza o status do usuário
$stmt = $conecta->prepare("UPDATE usuariosLeitura SET aprovado = ? WHERE id = ?");
$stmt->bind_param("ii", $aprovado, $id);
$stmt->execute();

// Busca os dados do usuário para o e-mail
$stmt = $conecta->prepare("SELECT nome, email FROM usuariosLeitura WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$usuario = $result->fetch_assoc();

if ($aprovado == 1 && $usuario) {
    $nome = $usuario['nome'];
    $email = $usuario['email'];

    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->Host = GHOST;
        $mail->SMTPAuth = true;
        $mail->Username = GUSER;
        $mail->Password = GPWD;
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom(GUSER, 'ONG Cacau');
        $mail->addAddress($email, $nome);

        $mail->isHTML(true);
		$mail->CharSet = 'UTF-8';
		$mail->Encoding = 'base64';

        $mail->Subject = 'Cadastro aprovado - ONG Cacau';

        $mail->Body = '
          <div style="background-color:#f5f5f5;padding:30px 0;font-family:Arial,sans-serif;">
            <div style="max-width:600px;margin:0 auto;background-color:#ffffff;border-radius:8px;overflow:hidden;box-shadow:0 0 10px rgba(0,0,0,0.05);">
              <div style="padding:20px;text-align:center;">
                <img src="' . URL_BASE . 'assets/images/Logo-CACAU.png" alt="ONG Cacau" style="max-width:180px;margin-bottom:20px;" />
                <h2 style="color:#333333;">Cadastro aprovado!</h2>
                <p style="color:#555555;font-size:16px;line-height:1.6;">
                  Olá <strong>' . $nome . '</strong>,
                </p>
                <p style="color:#555555;font-size:16px;line-height:1.6;">
                  Seu cadastro foi aprovado com sucesso! Você já pode acessar a área de vídeos da ONG Cacau.
                </p>
                <a href="' . URL_BASE . '" style="display:inline-block;margin-top:20px;padding:12px 24px;background-color:#4CAF50;color:#fff;text-decoration:none;border-radius:6px;font-weight:bold;">
                  Acessar vídeos
                </a>
                <p style="margin-top:30px;color:#888888;font-size:14px;">
                  Equipe da ONG Cacau
                </p>
              </div>
            </div>
          </div>
        ';

        $mail->AltBody = "Olá $nome,\n\nSeu cadastro foi aprovado! Agora você pode acessar a área de vídeos da ONG Cacau em: " . URL_BASE;

        $mail->send();
        header("Location: " . URL_BASE . "controle/usuariosLeitura");
        exit;
    } catch (Exception $e) {
        echo "Erro ao enviar e-mail: {$mail->ErrorInfo}";
    }
} else {
    header("Location: " . URL_BASE . "controle/usuariosLeitura");
    exit;
}
