<?php
set_time_limit(0);

function scan_dir($dir) {
    $infected = [];
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));

    foreach ($rii as $file) {
        if (!$file->isFile() || pathinfo($file, PATHINFO_EXTENSION) !== 'php') continue;

        $contents = file_get_contents($file);
        if (
            strpos($contents, 'eval(') !== false ||
            strpos($contents, 'base64_decode(') !== false ||
            strpos($contents, 'gzinflate(') !== false ||
            strpos($contents, 'shell_exec') !== false ||
            strpos($contents, 'system(') !== false ||
            preg_match('/\$[a-zA-Z0-9_]+\s*=\s*base64_decode\(/', $contents)
        ) {
            $infected[] = $file->getPathname();
        }
    }

    return $infected;
}

$path = __DIR__; // Caminho raiz (onde o scanner estiver)
$result = scan_dir($path);

echo "<h2>Arquivos potencialmente infectados:</h2>";
if (count($result) === 0) {
    echo "<p style='color:green;'>Nenhum arquivo suspeito encontrado. ??</p>";
} else {
    echo "<ul>";
    foreach ($result as $file) {
        echo "<li style='color:red;'>" . 
     htmlspecialchars($file) . 
     " <a href='deletar.php?file=" . urlencode($file) . "' onclick='return confirm(\"Tem certeza que quer deletar este arquivo?\")'>[Deletar]</a></li>";

    }
    echo "</ul>";
}

echo "<hr><p>Varredura completa em: $path</p>";
?>
