<?php
session_start();
if((!isset ($_SESSION['login']) == true) and (!isset ($_SESSION['password']) == true))
{
  unset($_SESSION['login']);
  unset($_SESSION['senha']);
  header('location:/?error=2');
  }

$email = $_SESSION['login'];
  
date_default_timezone_set('America/Sao_Paulo');
//$error = $_GET['error'];

include('/home/desenvwor/public_html/lp/config/lp.config.php');

function verificarDNS($dominio) {
    // Verifica registros A ou AAAA
    if (checkdnsrr($dominio, 'A') || checkdnsrr($dominio, 'AAAA')) {
        return "online";
    }
    
    // Verifica registros CNAME
    if (checkdnsrr($dominio, 'CNAME')) {
        return "online";
    }
    
    // Se nenhum registro foi encontrado
    return "offline";
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Works Midia LP - Domínios</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link rel="stylesheet" href="assets/css/style.css">
	<link rel="stylesheet" href="assets/css/admin.css">
</head>
<body class="body">

<div class="container">
    <div class="row">
        <div class="col-md-3 preBoxMenu">
            <?php
			include('menu.php');
			?>
        </div>
        <div class="col-md-9 boxContent">
            <h2 class="text-center"><span style="color: #fdc500;">Domínios</span> <span style="color: #0077b7;">Inseridos</span></h2>
			<div class="listSpace">
				<button type="button" class="btn btn-outline-info" data-toggle="modal" data-target="#insertDomain">
					<i class="fa-solid fa-circle-plus"></i> Inserir Domínio
				</button><br><br>
				<table class="table table-striped">
				  <thead>
					<tr>
					  <th scope="col">ID do Domínio</th>
					  <th scope="col">Endereço do Domínio</th>
					  <th scope="col"> </th>
					</tr>
				  </thead>
				  <tbody>
					<?php
					$sql1 = $conecta->query("SELECT * FROM dominios");
					while ($consulta1 = $sql1->fetch_assoc()){
					switch($consulta1['status']){
					case 0: $class = 'text-black-50';
					break;
					case 1: $class = 'text-dark';
					break;}
					$vf = verificarDNS($consulta1['enderecoDominio']);
					switch($vf){
					case 'online': $domCheck = '<i class="fa-solid fa-circle text-success"></i>';
								   $domLink = 'http://'.$consulta1['enderecoDominio'];
								   $domServer = '<i class="fa-solid fa-server text-black-50"></i>';
					break;
					case 'offline': $domCheck = '<i class="fa-solid fa-circle text-danger"></i>';
								    $domLink = URL_BASE.'domain/'.$consulta1['identificador'];
									$domConteudo = DOM_PADRAO;
									$domExplode = explode(".", $consulta1['enderecoDominio']);
									$domSubdomain = $domExplode[0];
									$domServer = '<a data-toggle="modal" data-target="#dnsConfig-'.$consulta1['identificador'].'" style="cursor: pointer;"><i class="fa-solid fa-server text-info"></i></a>';
					break;}
					?>
					<tr>
					  <th scope="row">
						<span class="<?php echo $class; ?>"><?php echo $consulta1['identificador']; ?>&nbsp;
						<a href="<?php echo $domLink; ?>" target="_blank" style="color: #0077b7; text-decoration: none;"><i class="fa-solid fa-arrow-up-right-from-square"></i></a></span>
					  </th>
					  <td><span class="<?php echo $class; ?>"><?php echo $consulta1['enderecoDominio']; ?></span></td>
					  <td>
						<?php echo $domCheck; ?>&nbsp;&nbsp;
						<?php echo $domServer; ?>&nbsp;&nbsp;
						<a data-toggle="modal" data-target="#excDominio-<?php echo $consulta1['identificador']; ?>" style="cursor: pointer;">
							<i class="fa-solid fa-trash-can text-danger"></i>
						</a>
					  </td>
					  
					<!-- Modal Copiar Entradas DNS -->
					<div class="modal fade" id="dnsConfig-<?php echo $consulta1['identificador']; ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
					  <div class="modal-dialog" role="document">
						<div class="modal-content">
						  <div class="modal-header">
							<h5 class="modal-title" id="exampleModalLabel">Configure o DNS do Domínio <?php echo $consulta1['enderecoDominio']; ?></h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
							  <span aria-hidden="true">&times;</span>
							</button>
						  </div>
						  <div class="modal-body">
							<div class="col">
							<h5>Configurar Domínio</h5>
								<p style="font-size:10pt;">
									<strong>Tipo de Entrada:</strong> CNAME<br>
									<strong>Nome:</strong> <span id="entDom-<?php echo $consulta1['identificador']; ?>">@</span>  <button class="btn btn-info btn-sm" onclick="copiarTexto('entDom-<?php echo $consulta1['identificador']; ?>')"><i class="fa-regular fa-copy"></i></button><br>
									<strong>Conteúdo:</strong> <span id="contDom-<?php echo $consulta1['identificador']; ?>"><?php echo $domConteudo; ?></span>  <button class="btn btn-info btn-sm" onclick="copiarTexto('contDom-<?php echo $consulta1['identificador']; ?>')"><i class="fa-regular fa-copy"></i></button><br>
									<strong>TTL:</strong> Auto
								</p>
							</div>
							
							<div class="col">
							<h5>Configurar Subdomínio</h5>
								<p style="font-size:10pt;">
									<strong>Tipo de Entrada:</strong> CNAME<br>
									<strong>Nome:</strong> <span id="entSDom-<?php echo $consulta1['identificador']; ?>"><?php echo $domSubdomain; ?></span>  <button class="btn btn-info btn-sm" onclick="copiarTexto('entSDom-<?php echo $consulta1['identificador']; ?>')"><i class="fa-regular fa-copy"></i></button><br>
									<strong>Conteúdo:</strong> <span id="contSDom-<?php echo $consulta1['identificador']; ?>"><?php echo $domConteudo; ?></span>  <button class="btn btn-info btn-sm" onclick="copiarTexto('contSDom-<?php echo $consulta1['identificador']; ?>')"><i class="fa-regular fa-copy"></i></button><br>
									<strong>TTL:</strong> Auto
								</p>
							</div>
							
						  </div>
						  <div class="modal-footer">
							<button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i> Fechar</button>
						  </div>
						</div>
					  </div>
					</div>
					
					<!-- Modal Exclusão -->
					<div class="modal fade" id="excDominio-<?php echo $consulta1['identificador']; ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
					  <div class="modal-dialog" role="document">
						<div class="modal-content">
						  <div class="modal-header">
							<h5 class="modal-title" id="exampleModalLabel">Excluir o Domínio <?php echo $consulta1['enderecoDominio']; ?></h5>
							<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
							  <span aria-hidden="true">&times;</span>
							</button>
						  </div>
						  <div class="modal-body">

							<h6>Deseja excluir o domínio <?php echo $consulta1['enderecoDominio']; ?> e todas as suas Land Pages?</h6>

						  </div>
						  <div class="modal-footer">
							<button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i> Fechar</button>
							<a href="alt_dominios.php?step=1&id=<?php echo $consulta1['identificador']; ?>" class="btn btn-outline-danger"><i class="fa-solid fa-trash-can"></i> Excluir</a>
						  </div>
						</div>
					  </div>
					</div>
					  
					</tr>
					
					<?php
					}
					?>
				  </tbody>
				</table>
			</div>
        </div>
    </div>
</div>

<!-- Modal Inserção do Domínio -->
<div class="modal fade" id="insertDomain" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Insira o Domínio</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
		<?php
		$id_1 = rand(10000, 99999);
		$id_2 = rand(10000, 99999);
		$nw_id = $id_1.'-'.$id_2;
		?>
		<form action="alt_dominios.php" method="GET">
		<div class="form-group">
            <input type="text" class="form-control" name="id" placeholder="Identificador" value="<?php echo $nw_id; ?>" readonly>
			<input type="hidden" name="step" value="0">
        </div>
		<div class="form-group">
            <input type="text" class="form-control" name="dominio" placeholder="Domínio (Formato: meudominio.com.br ou lp.meudominio.com.br)" REQUIRED>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><i class="fa-regular fa-circle-xmark"></i> Fechar</button>
        <button type="submit" class="btn btn-outline-info"><i class="fa-regular fa-floppy-disk"></i> Salvar Domínio</button>
		</form>
      </div>
    </div>
  </div>
</div>

<script>
function copiarTexto(elementId) {
    // Seleciona o elemento que contém o texto a partir do ID fornecido
    var texto = document.getElementById(elementId).innerText;

    // Usa a API Clipboard para copiar o texto
    navigator.clipboard.writeText(texto).then(function() {
        alert("Texto copiado: " + texto);
    }, function(err) {
        console.error('Erro ao copiar texto: ', err);
    });
}
</script>
    
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
<script src="https://kit.fontawesome.com/<?php echo FW_CODE; ?>.js" crossorigin="anonymous"></script>
</body>
</html>