document.addEventListener("DOMContentLoaded", function() {
  const tabela = document.getElementById("tabela");
  const linhas = tabela.getElementsByTagName("tr");
  const batchSize = 10;
  let paginaAtual = 1;
  const totalPaginas = Math.ceil((linhas.length - 1) / batchSize);

  function mostrarPagina(pagina) {
    for (let i = 0; i < linhas.length; i++) {
      if (i === 0 || (i >= (pagina - 1) * batchSize && i < pagina * batchSize + 1)) {
        linhas[i].style.display = "";
      } else {
        linhas[i].style.display = "none";
      }
    }
  }

  function atualizarBotoes() {
    document.getElementById("anterior").disabled = paginaAtual === 1;
    document.getElementById("proximo").disabled = paginaAtual === totalPaginas;
    document.getElementById("primeira").disabled = paginaAtual === 1;
    document.getElementById("ultima").disabled = paginaAtual === totalPaginas;
    document.getElementById("pagina-atual").textContent = paginaAtual;
    document.getElementById("total-paginas").textContent = totalPaginas;
  }

  document.getElementById("proximo").addEventListener("click", function() {
    if (paginaAtual < totalPaginas) {
      paginaAtual++;
      mostrarPagina(paginaAtual);
      atualizarBotoes();
    }
  });

  document.getElementById("anterior").addEventListener("click", function() {
    if (paginaAtual > 1) {
      paginaAtual--;
      mostrarPagina(paginaAtual);
      atualizarBotoes();
    }
  });

  document.getElementById("primeira").addEventListener("click", function() {
    paginaAtual = 1;
    mostrarPagina(paginaAtual);
    atualizarBotoes();
  });

  document.getElementById("ultima").addEventListener("click", function() {
    paginaAtual = totalPaginas;
    mostrarPagina(paginaAtual);
    atualizarBotoes();
  });

  mostrarPagina(paginaAtual);
  atualizarBotoes();
});